/*
 * Decompiled with CFR 0.152.
 */
package gui;

import Metareads.AssignReads1;
import Metareads.GetCountFreq;
import Metareads.PredictPara;
import Metareads.getMedianVal3;
import Metareads.separateFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;

public class rRNAFilter {
    public static String kmercount;
    public static String fileToBeProcessed;
    public static int readsType;
    public static int merlen;
    public static int mercount;

    public static String rev(String seq) {
        HashMap<String, String> seqmap = new HashMap<String, String>();
        seqmap.put("A", "T");
        seqmap.put("T", "A");
        seqmap.put("G", "C");
        seqmap.put("C", "G");
        StringBuilder sf = new StringBuilder();
        for (int k = seq.length() - 1; k > -1; --k) {
            sf.append(seq.substring(k, k + 1));
        }
        return sf.toString();
    }

    public static void delf(String fname) throws IOException {
        File file = new File(fname);
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                rRNAFilter.delf(f.getCanonicalPath());
            }
        }
        file.delete();
    }

    public static void main(String[] args) throws IOException, InterruptedException, FileNotFoundException, ExecutionException, SQLException {
        boolean flag = false;
        int m = 10;
        kmercount = "kanalyze.jar";
        File f = new File(kmercount);
        if (!f.exists() || f.isDirectory()) {
            System.out.println("\nERROR: rRNAFilter required software kanalyze does not exist.\n");
            System.out.println("\nPlease refer to the manual to install kanalyze.\n");
        } else if (args.length < 2) {
            System.out.println("\nPlease input reads file in fasta format:\n");
            System.out.println("\nUsage: java -jar -XmxN rRNAFilter.jar -i reads_files -r reads_type\n");
            System.out.println("\n-XmxN(for example:-Xmx7g): Specify the maximum size of the memory allocation pool for a Java Virtual Machine (JVM)\n");
            System.out.println("-i (Required): reads files in fasta format\n");
            System.out.println("-r (Optional): 0: filter all reads; 1: filter reads confidently, by default r=0 \n");
        } else if (args.length <= 4 || args.length >= 2) {
            fileToBeProcessed = null;
            readsType = 0;
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].equals("-i")) {
                    fileToBeProcessed = args[i + 1];
                }
                if (!args[i].equals("-r")) continue;
                readsType = Integer.parseInt(args[i + 1]);
            }
            if (fileToBeProcessed != null) {
                flag = true;
            } else {
                System.out.println("\nPlease input reads file in fasta format:\n");
                System.out.println("\nUsage: java -jar -XmxN rRNAFilter.jar -i reads_files -r reads_type\n");
                System.out.println("\n-XmxN(for example:-Xmx7g): Specify the maximum size of the memory allocation pool for a Java Virtual Machine (JVM)\n");
                System.out.println("-i (Required): reads files in fasta format\n");
                System.out.println("-r (Optional): 0: filter all reads; 1: filter reads confidently, be default r=0 \n");
            }
        }
        if (flag) {
            for (int k = 0; k < 10; ++k) {
                rRNAFilter.delf(fileToBeProcessed + "_split_" + k);
            }
            rRNAFilter.delf(fileToBeProcessed + "_rRNA");
            rRNAFilter.delf(fileToBeProcessed + "_non_filtered");
            rRNAFilter.delf(fileToBeProcessed + "_non-rRNA");
            Thread tthread = new Thread(new separateFile(fileToBeProcessed));
            tthread.start();
            System.out.print("\nCount frequency of k-mers:....\n");
            GetCountFreq.CountFreq(mercount, fileToBeProcessed);
            System.out.print("\nEstimate abundances by EM algorithm:....\n");
            Object[] alph = PredictPara.mainfile(fileToBeProcessed + "_counts_freq", m);
            rRNAFilter.delf(fileToBeProcessed + "_counts_freq");
            double[] lambda = (double[])alph[1];
            double dif = (lambda[1] - lambda[0]) / lambda[0];
            String folder = fileToBeProcessed.split("/")[fileToBeProcessed.split("/").length - 1];
            if (dif < 0.01) {
                try (PrintWriter writer1 = new PrintWriter(fileToBeProcessed + "_non-rRNA");){
                    BufferedReader br = new BufferedReader(new FileReader(fileToBeProcessed));
                    String line = br.readLine();
                    while (line != null) {
                        writer1.print(line + "\n");
                        line = br.readLine();
                    }
                }
            } else {
                System.out.print("\nFilter rRNA reads:....\n");
                while (tthread.isAlive()) {
                }
                tthread = new Thread(new getMedianVal3(folder + "/counts", lambda));
                tthread.start();
            }
            while (tthread.isAlive()) {
            }
            rRNAFilter.delf(folder + "/counts");
            for (int k = 0; k < 10; ++k) {
                rRNAFilter.delf(fileToBeProcessed + "_split_" + k);
            }
            rRNAFilter.delf(folder);
            if (readsType == 0) {
                f = new File(fileToBeProcessed + "_non_filtered");
                if (f.exists()) {
                    System.out.println("Filter remaining rRNA reads...");
                    AssignReads1.mainAssign(fileToBeProcessed);
                }
                rRNAFilter.delf(fileToBeProcessed + "_non_filtered");
            }
            System.out.print("\nDone.\n");
        }
    }

    static {
        merlen = 10;
        mercount = 20;
    }
}

