/*
 * Decompiled with CFR 0.152.
 */
package Metareads;

import gui.MainMenu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class GetCountFreq {
    public static void CountFreq(int m, String filename) throws IOException, InterruptedException {
        String folder = filename.split("/")[filename.split("/").length - 1];
        File f = new File(folder);
        f.mkdirs();
        String outf = folder + "/counts";
        String outf2 = filename + "_counts_freq";
        String cmdlist3 = "java -jar -Xms2G " + MainMenu.kmercount + " count -k " + MainMenu.mercount + " -f fasta -d 4 -rcanonical -o " + outf + " " + filename;
        Process p = Runtime.getRuntime().exec(cmdlist3);
        p.waitFor();
        System.gc();
        File f1 = new File(outf);
        if (f1.exists()) {
            ArrayList<Integer> keys;
            HashMap<Integer, Integer> count;
            try (BufferedReader br = new BufferedReader(new FileReader(outf));){
                String line = br.readLine();
                count = new HashMap<Integer, Integer>();
                keys = new ArrayList<Integer>();
                while (line != null) {
                    int num = Integer.parseInt(line.split("\t")[1]);
                    if (count.containsKey(num)) {
                        count.put(num, (Integer)count.get(num) + 1);
                    } else {
                        count.put(num, 1);
                        keys.add(num);
                    }
                    line = br.readLine();
                }
                br.close();
            }
            Collections.sort(keys);
            var12_10 = null;
            try (PrintWriter writer = new PrintWriter(outf2, "UTF-8");){
                for (Integer key : keys) {
                    writer.print(key + " " + count.get(key) + "\n");
                }
            }
            catch (Throwable throwable) {
                var12_10 = throwable;
                throw throwable;
            }
        }
        MainMenu.textArea1.append("\nError: k-mer counting program did not run. Please allocate proper memory to the command on line 28 of GetCountFreq.java and then rebuild MBBC.\n");
        System.exit(0);
    }
}

