/*
 * Decompiled with CFR 0.152.
 */
package Metareads;

import Metareads.fun;
import gui.MainMenu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class AssignReads1 {
    static String s = "ACGT";

    public static List<String> permute(int level, String prefix, List<String> out) {
        if (level == 0) {
            out.add(prefix);
            return out;
        }
        for (int i = 0; i < s.length(); ++i) {
            out = AssignReads1.permute(level - 1, prefix + s.charAt(i), out);
        }
        return out;
    }

    public static String rev(String line) {
        String revline = "";
        block12: for (int k = line.length() - 1; k > -1; --k) {
            switch (line.substring(k, k + 1)) {
                case "A": {
                    revline = revline + "T";
                    continue block12;
                }
                case "T": {
                    revline = revline + "A";
                    continue block12;
                }
                case "G": {
                    revline = revline + "C";
                    continue block12;
                }
                case "C": {
                    revline = revline + "G";
                    continue block12;
                }
                default: {
                    revline = revline + line.substring(k, k + 1);
                }
            }
        }
        return revline;
    }

    public static String[] getMersForEachreads(String line, int T) {
        String[] out = new String[line.length() - T + 1];
        for (int k = 0; k < line.length() - T + 1; ++k) {
            out[k] = line.substring(k, k + T);
        }
        return out;
    }

    public static Object[] getTransition(String fname1, List<String> allmers) throws InterruptedException, IOException {
        HashMap<String, Double> allcounts1 = new HashMap<String, Double>();
        int N = allmers.size();
        double[][] out = new double[2][N * 4];
        String[] mers = new String[N * 4];
        int p1 = 0;
        Iterator<String> iterator = allmers.iterator();
        while (iterator.hasNext()) {
            String key;
            String tmp = key = iterator.next();
            mers[p1++] = tmp + "A";
            mers[p1++] = tmp + "C";
            mers[p1++] = tmp + "G";
            mers[p1++] = tmp + "T";
        }
        String[] fname = new String[]{fname1 + "_rRNA", fname1 + "_non-rRNA"};
        for (int m = 0; m < 2; ++m) {
            File tmpf = new File(fname[m] + "_counts");
            if (tmpf.exists()) {
                tmpf.delete();
            }
            String cmdlist3 = "java -jar -Xms1g kanalyze.jar count -k " + MainMenu.merlen + " -f fasta -d 4 -rduplicate -o " + fname[m] + "_counts" + " " + fname[m];
            String outf = fname[m] + "_counts";
            Process p = Runtime.getRuntime().exec(cmdlist3);
            p.waitFor();
            System.gc();
            for (String string : allmers) {
                allcounts1.put(string + "A", 0.0);
                allcounts1.put(string + "C", 0.0);
                allcounts1.put(string + "G", 0.0);
                allcounts1.put(string + "T", 0.0);
            }
            Throwable throwable = null;
            try (BufferedReader br = new BufferedReader(new FileReader(outf));){
                String line = br.readLine();
                while (line != null) {
                    allcounts1.put(line.split("\t")[0], Double.parseDouble(line.split("\t")[1]));
                    line = br.readLine();
                }
            }
            catch (Throwable line) {
                Throwable throwable2 = line;
                throw line;
            }
            File f = new File(outf);
            if (f.exists()) {
                f.delete();
            }
            double[] data4 = new double[4];
            double[] dArray = new double[N * 4];
            int kk = 0;
            Iterator<String> iterator2 = allmers.iterator();
            while (iterator2.hasNext()) {
                String key3;
                String tmp = key3 = iterator2.next();
                data4[0] = (Double)allcounts1.get(tmp + "A");
                data4[1] = (Double)allcounts1.get(tmp + "C");
                data4[2] = (Double)allcounts1.get(tmp + "G");
                data4[3] = (Double)allcounts1.get(tmp + "T");
                if (data4[0] == 0.0) {
                    data4[0] = 1.0E-4;
                }
                if (data4[1] == 0.0) {
                    data4[1] = 1.0E-4;
                }
                if (data4[2] == 0.0) {
                    data4[2] = 1.0E-4;
                }
                if (data4[3] == 0.0) {
                    data4[3] = 1.0E-4;
                }
                double sums = fun.sum(data4);
                double t1 = data4[0] * 1.0 / sums;
                double t2 = data4[1] * 1.0 / sums;
                double t3 = data4[2] * 1.0 / sums;
                double t4 = data4[3] * 1.0 / sums;
                dArray[kk++] = t1;
                dArray[kk++] = t2;
                dArray[kk++] = t3;
                dArray[kk++] = t4;
            }
            out[m] = dArray;
        }
        HashMap<String, Integer> out2 = new HashMap<String, Integer>();
        for (int t = 0; t < mers.length; ++t) {
            out2.put(mers[t], t);
        }
        return new Object[]{out, out2};
    }

    public static String filterReads(String line) {
        String out = "";
        String allchar = "ACGT";
        for (int k = 0; k < line.length(); ++k) {
            if (!allchar.contains(line.substring(k, k + 1))) continue;
            out = out + line.charAt(k);
        }
        return out;
    }

    public static void getScores(Object[] data, String fname, String fout1, String fout2) throws FileNotFoundException, IOException {
        double[][] model = (double[][])data[0];
        HashMap mers = (HashMap)data[1];
        try (BufferedReader br = new BufferedReader(new FileReader(fname));){
            String name1 = br.readLine();
            while (name1 != null) {
                String line1 = br.readLine();
                line1 = AssignReads1.filterReads(line1);
                String[] seq1 = AssignReads1.getMersForEachreads(line1, MainMenu.merlen);
                String[] seq11 = AssignReads1.getMersForEachreads(AssignReads1.rev(line1), MainMenu.merlen);
                double[] scores = new double[2];
                for (int k = 0; k < 2; ++k) {
                    double[] model1 = model[k];
                    double s1 = 0.0;
                    double s2 = 0.0;
                    for (int t = 0; t < seq1.length; ++t) {
                        s1 += model1[(Integer)mers.get(seq1[t])];
                        s2 += model1[(Integer)mers.get(seq11[t])];
                    }
                    scores[k] = Math.max(s1, s2);
                }
                int maxs = fun.maxindex(scores);
                String out = maxs == 1 ? fout2 : fout1;
                fname = fname.split("_non_filtered")[0];
                try (FileWriter writer1 = new FileWriter(fname + "_" + out, true);){
                    writer1.write(name1 + "\n");
                    writer1.write(line1 + "\n");
                }
                name1 = br.readLine();
            }
        }
    }

    public static void mainAssign(String fname) throws FileNotFoundException, IOException, InterruptedException, ExecutionException {
        int Nmer = MainMenu.merlen;
        List<String> allmers = new ArrayList<String>();
        allmers = AssignReads1.permute(Nmer - 1, "", allmers);
        MainMenu.textArea1.append("\nTrain two Markov chains....\n");
        Object[] model = AssignReads1.getTransition(fname, allmers);
        MainMenu.textArea1.append("\nAssign reads to one of Markov chains....\n");
        AssignReads1.getScores(model, fname + "_non_filtered", "rRNA", "non-rRNA");
    }

    public static void mainAssign(Object[] alph, String file1, String file2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

